#!/bin/bash
#
# usage: pass a file (arg1) to print to all the printers that match the searchKey

#echo "Argument 0 is: $0"
#echo "Argument 1 is: $1"
#echo "Argument 2 is: [$2]"

searchKey='TSP143|TSP100'

allPrinters=($(/usr/libexec/cups/backend/usb|awk  "/${searchKey}/"' {print $2}'))
for prn in ${allPrinters[@]};do
    prn=${prn//\?/\\?}
    prn=${prn//\(/\\(}
    prn=${prn//\)/\\)}
    prn=${prn//\//\\/}
    queueName+=($(lpstat -v|awk "/${prn}/"' {sub(":$","",$3);print $3}'))
done

#queueName=($(lpstat -v|awk "/${searchKey}/"' {sub(":$","",$3);print $3}'))

if ((0 == ${#queueName[@]})); then
    echo no-printers-available
    exit 0
else
    echo >&2 printer count is ${#queueName[@]} 
fi

#printerQueueName=~/Library/Printers/DNP\ DS40.app
#printerName="Dai_Nippon_Printing_DS40"

EXITSTATUS=0

#this will open item in appropriate app - ie if image file - opens preview.app
#open "$1"

if test -r "$1";then

  for q in ${queueName[@]};do
    printerDescription=$(lpstat -l -p ${q}|awk '/^[ \t]*Description:/ {s=$0;sub("^[ \t]*" $1 " ","",s);print s}')

    printerApp=~/Library/Printers/${printerDescription}.app

# 2019-02-14steve - open in background =>  -g
    open -g "${printerApp}"
    echo sending job \"$1\" to $q
lp -o portrait -d ${q} "$1"
# lp -o portrait -o media=Letter -d ${q} "$1"
#   lp -o fit-to-page -o media=Letter -d ${q} "$1"
#   lp -o orientation-requested=6 -d "${queueName}" "$1"
  done
else
  echo Error: failed to pass a file to print in arg 1
  /usr/bin/false
fi




EXITSTATUS=$?

if [ $EXITSTATUS != 0 ]
then
	echo "ExitStatus failed??"
else
	echo "ExitStatus PASSED!"
fi 


exit $EXITSTATUS

